/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyComboBoxUI;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicTextFieldUI;

public abstract class MyBox
extends JPanel {
    protected static final int SAISIE = 0;
    protected static final int AFFICHAGE = 1;
    private static final String LABEL_SAISIE = "SAISIE";
    private static final String LABEL_AFFICHAGE = "AFFICHAGE";
    protected static String UNDEF = "";
    protected Aladin aladin;
    protected Text pos;
    protected Text text;
    private int mode = 1;
    private CardLayout cl;
    private JPanel cardPanel;
    protected JComboBox c;
    protected JLabel label;
    private static int POSCROSS;

    protected MyBox() {
    }

    protected MyBox(Aladin aladin, String titre) {
        this.aladin = aladin;
        this.c = this.createChoice();
        this.pos = new Text("", 30);
        this.pos.setFont(Aladin.PLAIN);
        this.pos.setBackground(Aladin.COLOR_TEXT_BACKGROUND);
        this.pos.setForeground(Aladin.COLOR_TEXT_FOREGROUND_INFO);
        this.text = new Text("", 30);
        this.text.setFont(Aladin.PLAIN);
        this.text.setBackground(Aladin.COLOR_TEXT_BACKGROUND);
        this.text.setForeground(Aladin.COLOR_TEXT_FOREGROUND);
        this.cl = new CardLayout(0, 0);
        this.cardPanel = new JPanel(this.cl);
        this.cardPanel.add(LABEL_AFFICHAGE, this.pos);
        this.cardPanel.add(LABEL_SAISIE, this.text);
        this.cardPanel.setBackground(aladin.getBackground());
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(aladin.getBackground());
        this.label = new Lab(titre);
        this.add((Component)this.label, "West");
        this.add((Component)this.cardPanel, "Center");
        JPanel p1 = new JPanel(new BorderLayout(0, 0));
        p1.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 30));
        p1.add((Component)new Lab(Aladin.chaine.getString("FRAME") + " "), "West");
        GridBagLayout g = new GridBagLayout();
        JPanel pCombo = new JPanel(g);
        pCombo.setBackground(aladin.getBackground());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        pCombo.add((Component)this.c, gc);
        p1.add((Component)pCombo, "Center");
        p1.setBackground(aladin.getBackground());
        this.add((Component)p1, "East");
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
    }

    protected JComboBox getComboBox() {
        return this.c;
    }

    @Override
    public void setEnabled(boolean flag) {
        this.text.setEnabled(flag);
        this.text.setBackground(flag ? Color.white : this.getBackground());
        if (!flag) {
            this.text.setText("");
        }
        this.pos.setBackground(flag ? Color.white : this.getBackground());
        this.label.setForeground(flag ? Aladin.COLOR_LABEL : Color.lightGray);
        this.c.setEnabled(flag);
    }

    protected boolean isPopupVisible() {
        return this.c.isPopupVisible();
    }

    protected JComboBox createChoice() {
        JComboBox c = new JComboBox();
        c.setUI(new MyComboBoxUI());
        c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MyBox.this.actionChoice();
            }
        });
        return c;
    }

    protected abstract void actionChoice();

    protected void setTextSaisie(String s) {
        this.text.setText(s);
        if (s.length() > 0) {
            this.text.select(0, 0);
        }
    }

    protected void setTextAffichage(String s) {
        this.pos.setText(s);
    }

    protected void reset() {
        this.text.setText("");
        this.pos.setText("");
    }

    protected void triangleAction(int x) {
    }

    protected void crossAction() {
        this.text.setText("");
    }

    protected boolean hasTriangle() {
        return false;
    }

    protected boolean hasCross() {
        return this.text.getText().length() > 0;
    }

    protected void readyToClear() {
        this.text.selectAll();
    }

    protected String getTextAffichage() {
        return this.pos.getText().trim();
    }

    protected String getTextSaisie() {
        return this.text.getText().trim();
    }

    protected void setMode(int m) {
        if (this.mode == m) {
            return;
        }
        this.mode = m;
        this.cl.show(this.cardPanel, this.mode == 0 ? LABEL_SAISIE : LABEL_AFFICHAGE);
    }

    protected void setUndef() {
        this.pos.setText(UNDEF);
    }

    protected int getChoiceIndex() {
        return this.c.getSelectedIndex();
    }

    protected void setChoiceIndex(int m) {
        this.c.setSelectedIndex(m);
    }

    protected void sendKey(KeyEvent e) {
    }

    class Text
    extends JTextField
    implements MouseMotionListener,
    MouseListener {
        private Rectangle region;
        private Rectangle regionCross;
        private Color colorTriangle;
        int w;
        private Cursor cursor;

        Text(String t, int width) {
            super(t, width);
            this.region = null;
            this.regionCross = null;
            this.colorTriangle = Color.darkGray;
            this.cursor = null;
            this.setUI(new BasicTextFieldUI());
            this.addMouseMotionListener(this);
            MyBox myBox = MyBox.this;
            this.w = Math.round(10.0f * myBox.aladin.getUIScale());
            POSCROSS = 25 + this.w;
            this.addMouseListener(this);
            Insets i = this.getMargin();
            i.right = POSCROSS + 1;
            this.setMargin(i);
        }

        boolean in(int x, int y) {
            return this.region != null && x >= this.region.x;
        }

        boolean inCross(int x, int y) {
            return this.regionCross != null && x >= this.regionCross.x && x <= this.regionCross.x + this.regionCross.width;
        }

        @Override
        public void paintComponent(Graphics g) {
            try {
                super.paintComponent(g);
                if (MyBox.this.hasCross()) {
                    g.setColor(this.getBackground());
                    g.fillRect(this.getWidth() - POSCROSS, 0, this.getWidth() - 16, this.getHeight());
                    this.drawCross(g, this.getWidth() - (POSCROSS - 2), this.getHeight() / 2 - 4);
                }
                if (MyBox.this.hasTriangle()) {
                    g.setColor(this.getBackground());
                    g.fillRect(this.getWidth() - POSCROSS + 14, 0, this.getWidth() - 1, this.getHeight());
                    this.drawTriangle(g, this.getWidth() - POSCROSS + 15, this.getHeight() / 2 - 2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void drawCross(Graphics g, int x, int y) {
            g.setColor(this.colorTriangle);
            Util.drawCross(g, x, y, this.w - 4);
            this.regionCross = new Rectangle(x - 2, y - 2, this.w, this.w);
        }

        private void drawTriangle(Graphics g, int x, int y) {
            g.setColor(this.colorTriangle);
            MyBox myBox = MyBox.this;
            if ((double)myBox.aladin.getUIScale() < 1.25) {
                Util.fillTriangle7(g, x, y);
            } else {
                Util.fillTriangle8(g, x, y);
            }
            this.region = new Rectangle(x - 2, y - 2, this.w, this.w);
        }

        @Override
        protected void processComponentKeyEvent(KeyEvent e) {
            int key = e.getKeyCode();
            if (e.getID() == 401 && (key == 38 || key == 40 || key == 34)) {
                MyBox.this.sendKey(e);
            } else {
                super.processComponentKeyEvent(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Cursor nc = MyBox.this.text.in(e.getX(), e.getY()) ? Cursor.getPredefinedCursor(12) : (MyBox.this.text.inCross(e.getX(), e.getY()) ? Cursor.getPredefinedCursor(12) : Cursor.getPredefinedCursor(2));
            if (nc.equals(this.cursor)) {
                return;
            }
            this.setCursor(nc);
            this.cursor = nc;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (MyBox.this.aladin.inHelp) {
                Aladin cfr_ignored_0 = MyBox.this.aladin;
                MyBox.this.aladin.help.setText(Aladin.chaine.getString("LCoord.HELP"));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (MyBox.this.aladin.inHelp) {
                MyBox.this.aladin.helpOff();
            }
            if (MyBox.this.text.in(e.getX(), e.getY())) {
                MyBox.this.triangleAction(e.getX());
            }
            if (MyBox.this.text.inCross(e.getX(), e.getY())) {
                MyBox.this.crossAction();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class Lab
    extends JLabel {
        Lab(String t) {
            super(t, 4);
            this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 2));
            this.setFont(Aladin.BOLD);
            this.setForeground(Aladin.COLOR_LABEL);
        }
    }
}

